
library(memisc)


library(mclogit)


load("model-churchat-cathprot-soclife-context.RData")


ls()


setCoefTemplate("horizontal.nostar"=t(c(est="($est:#)", se="(($se:#))")))


getCoefTemplate("horizontal.nostar")


m_soclife <- mtable(model_soclife,
                    coef.style="horizontal.nostar",
                    getSummary=getSummary.mmclogit,
                    gs.options=list(
                        rearrange=list(
                            "Social Lifestyle" = c("Squared" = "sociallifestyle.sq",                        
                                                "Linear"  = "sociallifestyle",                           
                                                "$\\times$ attends rarely"      = "sociallifestyle:relattRarely",
                                                "$\\times$ attends on holidays" = "sociallifestyle:relattHolidays",
                                                "$\\times$ attends monthly"     = "sociallifestyle:relattMonthly",
                                                "$\\times$ attends weely"       = "sociallifestyle:relattWeekly",
                                                "$\\times$ Protestant"          = "sociallifestyle:cathprotProtestant",
                                                "$\\times$ attends rarely      $\\times$ Protestant"      = "sociallifestyle:relattRarely:cathprotProtestant",
                                                "$\\times$ attends on holidays $\\times$ Protestant"      = "sociallifestyle:relattHolidays:cathprotProtestant",
                                                "$\\times$ attends monthly     $\\times$ Protestant"      = "sociallifestyle:relattMonthly:cathprotProtestant",
                                                "$\\times$ attends weely       $\\times$ Protestant"      = "sociallifestyle:relattWeekly:cathprotProtestant",
                                                "$\\times$ self-employed"  = "sociallifestyle:oesch8Self-employed",       
                                                "$\\times$ technical"      = "sociallifestyle:oesch8Technical",           
                                                "$\\times$ management"     = "sociallifestyle:oesch8Management",          
                                                "$\\times$ clerks"         = "sociallifestyle:oesch8Clerks",              
                                                "$\\times$ socio-cultural" = "sociallifestyle:oesch8Socio-cultural",      
                                                "$\\times$ service worker" = "sociallifestyle:oesch8Service worker",      
                                                "$\\times$ primary sector" = "sociallifestyle:oesch8Primary sector",      
                                                "$\\times$ secularized"                  = "sociallifestyle:No_religion",
                                                "$\\times$ denominational balance"       = "sociallifestyle:Cath_Prot",
                                                "$\\times$ denominational heterogeneity" = "sociallifestyle:Denom_Het",
                                                "$\\times$ time" = "sociallifestyle:time", 
                                                "$\\times$ attends rarely      $\\times$ time"  = "sociallifestyle:relattRarely:time",
                                                "$\\times$ attends on holidays $\\times$ time"  = "sociallifestyle:relattHolidays:time",
                                                "$\\times$ attends weekly      $\\times$ time"  = "sociallifestyle:relattMonthly:time",
                                                "$\\times$ attends daily       $\\times$ time"  = "sociallifestyle:relattWeekly:time",
                                                "$\\times$ Protestant     $\\times$ time"  = "sociallifestyle:cathprotProtestant:time",
                                                "$\\times$ attends rarely      $\\times$ Protestant $\\times$ time"  = "sociallifestyle:relattRarely:cathprotProtestant:time",
                                                "$\\times$ attends on holidays $\\times$ Protestant $\\times$ time"  = "sociallifestyle:relattHolidays:cathprotProtestant:time",
                                                "$\\times$ attends monthly     $\\times$ Protestant $\\times$ time"  = "sociallifestyle:relattMonthly:cathprotProtestant:time",
                                                "$\\times$ attends weely       $\\times$ Protestant $\\times$ time"  = "sociallifestyle:relattWeekly:cathprotProtestant:time",
                                                "$\\times$ self-employed  $\\times$ time"  = "sociallifestyle:oesch8Self-employed:time",  
                                                "$\\times$ technical      $\\times$ time"  = "sociallifestyle:oesch8Technical:time",      
                                                "$\\times$ management     $\\times$ time"  = "sociallifestyle:oesch8Management:time",     
                                                "$\\times$ clerks         $\\times$ time"  = "sociallifestyle:oesch8Clerks:time",         
                                                "$\\times$ socio-cultural $\\times$ time"  = "sociallifestyle:oesch8Socio-cultural:time", 
                                                "$\\times$ service worker $\\times$ time"  = "sociallifestyle:oesch8Service worker:time", 
                                                "$\\times$ primary sector $\\times$ time"  = "sociallifestyle:oesch8Primary sector:time"),                                  
                            "Immigration" = c("Squared" = "immigration.sq",                                 
                                              "Linear"  = "immigration",               
                                              "$\\times$ attends rarely"      = "relattRarely:immigration",
                                              "$\\times$ attends on holidays" = "relattHolidays:immigration",
                                              "$\\times$ attends monthly"     = "relattMonthly:immigration",
                                              "$\\times$ attends weely"       = "relattWeekly:immigration",
                                              "$\\times$ Protestant"          = "cathprotProtestant:immigration",
                                              "$\\times$ self-employed"  = "oesch8Self-employed:immigration",       
                                              "$\\times$ technical"      = "oesch8Technical:immigration",           
                                              "$\\times$ management"     = "oesch8Management:immigration",          
                                              "$\\times$ clerks"         = "oesch8Clerks:immigration",              
                                              "$\\times$ socio-cultural" = "oesch8Socio-cultural:immigration",      
                                              "$\\times$ service worker" = "oesch8Service worker:immigration",      
                                              "$\\times$ primary sector" = "oesch8Primary sector:immigration",      
                                              "$\\times$ time" = "time:immigration", 
                                              "$\\times$ attends rarely      $\\times$ time"  = "relattRarely:time:immigration",
                                              "$\\times$ attends on holidays $\\times$ time"  = "relattHolidays:time:immigration",
                                              "$\\times$ attends weekly      $\\times$ time"  = "relattMonthly:time:immigration",
                                              "$\\times$ attends daily       $\\times$ time"  = "relattWeekly:time:immigration",
                                              "$\\times$ Protestant     $\\times$ time"  = "cathprotProtestant:time:immigration",
                                              "$\\times$ self-employed  $\\times$ time"  = "oesch8Self-employed:time:immigration",  
                                              "$\\times$ technical      $\\times$ time"  = "oesch8Technical:time:immigration",      
                                              "$\\times$ management     $\\times$ time"  = "oesch8Management:time:immigration",     
                                              "$\\times$ clerks         $\\times$ time"  = "oesch8Clerks:time:immigration",         
                                              "$\\times$ socio-cultural $\\times$ time"  = "oesch8Socio-cultural:time:immigration", 
                                              "$\\times$ service worker $\\times$ time"  = "oesch8Service worker:time:immigration", 
                                              "$\\times$ primary sector $\\times$ time"  = "oesch8Primary sector:time:immigration"),   
                            "Econ Left--Right"= c("Squared" = "lrecon.sq",
                                              "Linear"  = "lrecon",
                                              "$\\times$ attends rarely"      = "relattRarely:lrecon",
                                              "$\\times$ attends on holidays" = "relattHolidays:lrecon",
                                              "$\\times$ attends monthly"     = "relattMonthly:lrecon",
                                              "$\\times$ attends weely"       = "relattWeekly:lrecon",
                                              "$\\times$ Protestant"          = "cathprotProtestant:lrecon",
                                              "$\\times$ self-employed"  = "oesch8Self-employed:lrecon",       
                                              "$\\times$ technical"      = "oesch8Technical:lrecon",           
                                              "$\\times$ management"     = "oesch8Management:lrecon",          
                                              "$\\times$ clerks"         = "oesch8Clerks:lrecon",              
                                              "$\\times$ socio-cultural" = "oesch8Socio-cultural:lrecon",      
                                              "$\\times$ service worker" = "oesch8Service worker:lrecon",      
                                              "$\\times$ primary sector" = "oesch8Primary sector:lrecon",      
                                              "$\\times$ time" = "time:lrecon", 
                                              "$\\times$ attends rarely      $\\times$ time"  = "relattRarely:time:lrecon",
                                              "$\\times$ attends on holidays $\\times$ time"  = "relattHolidays:time:lrecon",
                                              "$\\times$ attends weekly      $\\times$ time"  = "relattMonthly:time:lrecon",
                                              "$\\times$ attends daily       $\\times$ time"  = "relattWeekly:time:lrecon",
                                              "$\\times$ Protestant     $\\times$ time"  = "cathprotProtestant:time:lrecon",
                                              "$\\times$ self-employed  $\\times$ time"  = "oesch8Self-employed:time:lrecon",  
                                              "$\\times$ technical      $\\times$ time"  = "oesch8Technical:time:lrecon",      
                                              "$\\times$ management     $\\times$ time"  = "oesch8Management:time:lrecon",     
                                              "$\\times$ clerks         $\\times$ time"  = "oesch8Clerks:time:lrecon",         
                                              "$\\times$ socio-cultural $\\times$ time"  = "oesch8Socio-cultural:time:lrecon", 
                                              "$\\times$ service worker $\\times$ time"  = "oesch8Service worker:time:lrecon", 
                                              "$\\times$ primary sector $\\times$ time"  = "oesch8Primary sector:time:lrecon")
                        )))


m_soclife


m_soclife |> 
    relabel("Var(~(Const.)|CHES_id" = "Var(Party",
            "essround" = "ESS round",
            "CHES_id:" = "Party $\\times$ ",
            "Party x" = "Party $\\times$ ",
            "CHES_id" = "Party",
            fixed=TRUE,gsub=TRUE) |>
    toLatex() |> writeLines(con="churchat-context-soclife/mtable-churchat-cathprot-context-soclife.tex")




